import { StarXpandCommand } from "star-io10-web";

export class LabelSample03_For300dpi_BarcodeLabel1_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(48.7)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(48.7, 24.0),
              new StarXpandCommand.PageModeBuilder()
                .styleHorizontalPositionTo(2.0)
                .styleVerticalPositionTo(3.0)
                .add(
                  new StarXpandCommand.PageModeBuilder()
                    .styleBold(true)
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .actionPrintText("${shop_name}\n"),
                )
                .styleHorizontalPositionTo(2.0)
                .styleVerticalPositionBy(1.0)
                .actionPrintText("${product_name}\n")
                .styleHorizontalPositionTo(2.0)
                .styleVerticalPositionBy(1.0)
                .actionPrintText("${product_number}\n")
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(48.7, 10.0)
                    .setX(0.0)
                    .setY(14.0),
                  new StarXpandCommand.PageModeBuilder()
                    .styleHorizontalPositionTo(4.0)
                    .styleVerticalPositionTo(6.0)
                    .actionPrintBarcode(
                      new StarXpandCommand.Printer.BarcodeParameter(
                        "${sku}",
                        StarXpandCommand.Printer.BarcodeSymbology.UpcA,
                      )
                        .setBarDots(3)
                        .setHeight(8.0)
                        .setPrintHri(true),
                    )
                    .styleVerticalPositionTo(1.0)
                    .actionPrintText(
                      "MSRP ${msrp%.2f} \n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        48,
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Right,
                        ),
                      ),
                    )
                    .add(
                      new StarXpandCommand.PageModeBuilder()
                        .styleBold(true)
                        .styleHorizontalPositionTo(31.0)
                        .styleMagnification(
                          new StarXpandCommand.MagnificationParameter(2, 2),
                        )
                        .styleVerticalPositionBy(3.0)
                        .actionPrintText("${selling_price% .2f}\n"),
                    ),
                ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "shop_name" : "STAR SHOP",
    "product_name" : "Star Sunglasses",
    "product_number" : "Star-01BK",
    "sku" : "012345789012",
    "msrp" : 429.0,
    "selling_price" : 389.99
}`,
    );
  }
}
